/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import jpcsp.HLE.VFS.AbstractProxyVirtualFileSystem;
import jpcsp.HLE.VFS.ByteArrayVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.util.Utilities;

public class CompressPrxVirtualFileSystem
extends AbstractProxyVirtualFileSystem {
    private static Map<String, Integer> prxModAttribute;
    private static Map<String, Boolean> prxKle4Compression;

    public CompressPrxVirtualFileSystem(IVirtualFileSystem vfs) {
        super(vfs);
        if (prxModAttribute == null) {
            this.initPrxMappings();
        }
    }

    private void addModAttribute(String prefix, String prx, int modAttribute) {
        prxModAttribute.put(prx, modAttribute);
        if (prefix != null) {
            prxModAttribute.put(prefix + prx, modAttribute);
        }
    }

    private void addKdModAttribute(String prx, int modAttribute) {
        this.addModAttribute("kd/", prx, modAttribute);
    }

    private void addVshModAttribute(String prx, int modAttribute) {
        this.addModAttribute("vsh/module/", prx, modAttribute);
    }

    private void initPrxMappings() {
        prxModAttribute = new HashMap<String, Integer>();
        this.addKdModAttribute("_galaxy.prx", 4102);
        this.addKdModAttribute("_inferno.prx", 4096);
        this.addKdModAttribute("_march33.prx", 257);
        this.addKdModAttribute("_popcorn.prx", 4103);
        this.addKdModAttribute("_stargate.prx", 4103);
        this.addKdModAttribute("_systemctrl.prx", 12295);
        this.addKdModAttribute("_usbdevice.prx", 4102);
        this.addKdModAttribute("_vshctrl.prx", 4103);
        this.addKdModAttribute("amctrl.prx", 20487);
        this.addKdModAttribute("ata.prx", 4103);
        this.addKdModAttribute("audio.prx", 4103);
        this.addKdModAttribute("audiocodec_260.prx", 4102);
        this.addKdModAttribute("avcodec.prx", 4102);
        this.addKdModAttribute("cert_loader.prx", 4102);
        this.addKdModAttribute("chkreg.prx", 20486);
        this.addKdModAttribute("chnnlsv.prx", 20486);
        this.addKdModAttribute("clockgen.prx", 4103);
        this.addKdModAttribute("codec_01g.prx", 4103);
        this.addKdModAttribute("codepage.prx", 4103);
        this.addKdModAttribute("ctrl.prx", 4103);
        this.addKdModAttribute("display_01g.prx", 4103);
        this.addKdModAttribute("dmacman.prx", 4103);
        this.addKdModAttribute("exceptionman.prx", 4103);
        this.addKdModAttribute("fatms.prx", 4103);
        this.addKdModAttribute("g729.prx", 4102);
        this.addKdModAttribute("ge.prx", 4103);
        this.addKdModAttribute("hpremote_01g.prx", 4103);
        this.addKdModAttribute("http_storage.prx", 4102);
        this.addKdModAttribute("idstorage.prx", 4103);
        this.addKdModAttribute("ifhandle.prx", 4102);
        this.addKdModAttribute("impose_01g.prx", 4103);
        this.addKdModAttribute("init.prx", 4102);
        this.addKdModAttribute("interruptman.prx", 4103);
        this.addKdModAttribute("iofilemgr.prx", 4103);
        this.addKdModAttribute("iofilemgr_dnas.prx", 4103);
        this.addKdModAttribute("irda.prx", 4102);
        this.addKdModAttribute("isofs.prx", 4103);
        this.addKdModAttribute("led.prx", 4103);
        this.addKdModAttribute("lfatfs.prx", 4103);
        this.addKdModAttribute("lflash_fatfmt.prx", 4102);
        this.addKdModAttribute("libaac.prx", 6);
        this.addKdModAttribute("libasfparser.prx", 2);
        this.addKdModAttribute("libatrac3plus.prx", 6);
        this.addKdModAttribute("libaudiocodec2.prx", 6);
        this.addKdModAttribute("libdnas.prx", 6);
        this.addKdModAttribute("libdnas_core.prx", 4102);
        this.addKdModAttribute("libgameupdate.prx", 0);
        this.addKdModAttribute("libhttp.prx", 6);
        this.addKdModAttribute("libmp3.prx", 6);
        this.addKdModAttribute("libmp4.prx", 6);
        this.addKdModAttribute("libparse_http.prx", 6);
        this.addKdModAttribute("libparse_uri.prx", 6);
        this.addKdModAttribute("libssl.prx", 6);
        this.addKdModAttribute("libupdown.prx", 6);
        this.addKdModAttribute("loadcore.prx", 12295);
        this.addKdModAttribute("loadexec_01g.prx", 12295);
        this.addKdModAttribute("lowio.prx", 4103);
        this.addKdModAttribute("mcctrl.prx", 20486);
        this.addKdModAttribute("me_wrapper.prx", 4103);
        this.addKdModAttribute("mediaman.prx", 4103);
        this.addKdModAttribute("mediasync.prx", 4103);
        this.addKdModAttribute("memab.prx", 4102);
        this.addKdModAttribute("memlmd_01g.prx", 28679);
        this.addKdModAttribute("mesg_led_01g.prx", 28679);
        this.addKdModAttribute("mgr.prx", 4102);
        this.addKdModAttribute("mgvideo.prx", 4102);
        this.addKdModAttribute("mlnbridge.prx", 4102);
        this.addKdModAttribute("mlnbridge_msapp.prx", 4102);
        this.addKdModAttribute("modulemgr.prx", 12295);
        this.addKdModAttribute("mp4msv.prx", 0);
        this.addKdModAttribute("mpeg.prx", 6);
        this.addKdModAttribute("mpeg_vsh.prx", 6);
        this.addKdModAttribute("mpegbase_260.prx", 4102);
        this.addKdModAttribute("msaudio.prx", 4102);
        this.addKdModAttribute("msstor.prx", 4103);
        this.addKdModAttribute("np.prx", 6);
        this.addKdModAttribute("np_auth.prx", 6);
        this.addKdModAttribute("np_campaign.prx", 6);
        this.addKdModAttribute("np_commerce2.prx", 6);
        this.addKdModAttribute("np_commerce2_regcam.prx", 6);
        this.addKdModAttribute("np_commerce2_store.prx", 6);
        this.addKdModAttribute("np_core.prx", 4102);
        this.addKdModAttribute("np_inst.prx", 20486);
        this.addKdModAttribute("np_matching2.prx", 6);
        this.addKdModAttribute("np_service.prx", 6);
        this.addKdModAttribute("np9660.prx", 4103);
        this.addKdModAttribute("npdrm.prx", 20486);
        this.addKdModAttribute("openpsid.prx", 20487);
        this.addKdModAttribute("pops_01g.prx", 0);
        this.addKdModAttribute("popsman.prx", 4103);
        this.addKdModAttribute("power_01g.prx", 4103);
        this.addKdModAttribute("psheet.prx", 4102);
        this.addKdModAttribute("pspnet.prx", 6);
        this.addKdModAttribute("pspnet_adhoc.prx", 6);
        this.addKdModAttribute("pspnet_adhoc_auth.prx", 4102);
        this.addKdModAttribute("pspnet_adhoc_discover.prx", 6);
        this.addKdModAttribute("pspnet_adhoc_download.prx", 6);
        this.addKdModAttribute("pspnet_adhoc_matching.prx", 6);
        this.addKdModAttribute("pspnet_adhoc_transfer_int.prx", 6);
        this.addKdModAttribute("pspnet_adhocctl.prx", 6);
        this.addKdModAttribute("pspnet_apctl.prx", 6);
        this.addKdModAttribute("pspnet_inet.prx", 6);
        this.addKdModAttribute("pspnet_resolver.prx", 6);
        this.addKdModAttribute("pspnet_upnp.prx", 6);
        this.addKdModAttribute("pspnet_wispr.prx", 6);
        this.addKdModAttribute("registry.prx", 4103);
        this.addKdModAttribute("rtc.prx", 4103);
        this.addKdModAttribute("sc_sascore.prx", 4102);
        this.addKdModAttribute("semawm.prx", 20486);
        this.addKdModAttribute("sircs.prx", 4102);
        this.addKdModAttribute("syscon.prx", 4103);
        this.addKdModAttribute("sysmem.prx", 4103);
        this.addKdModAttribute("systimer.prx", 4103);
        this.addKdModAttribute("threadman.prx", 4103);
        this.addKdModAttribute("umd9660.prx", 4103);
        this.addKdModAttribute("umdman.prx", 4103);
        this.addKdModAttribute("usb.prx", 4103);
        this.addKdModAttribute("usbacc.prx", 4102);
        this.addKdModAttribute("usbcam.prx", 4102);
        this.addKdModAttribute("usbgps.prx", 4102);
        this.addKdModAttribute("usbmic.prx", 4102);
        this.addKdModAttribute("usbpspcm.prx", 4102);
        this.addKdModAttribute("usbstor.prx", 4102);
        this.addKdModAttribute("usbstorboot.prx", 20486);
        this.addKdModAttribute("usbstormgr.prx", 4102);
        this.addKdModAttribute("usbstorms.prx", 4102);
        this.addKdModAttribute("usersystemlib.prx", 7);
        this.addKdModAttribute("utility.prx", 4103);
        this.addKdModAttribute("vaudio.prx", 4102);
        this.addKdModAttribute("videocodec_260.prx", 4102);
        this.addKdModAttribute("vshbridge.prx", 4103);
        this.addKdModAttribute("vshbridge_msapp.prx", 4103);
        this.addKdModAttribute("wlan.prx", 4103);
        this.addKdModAttribute("wlanfirm_01g.prx", 4103);
        this.addVshModAttribute("_recovery.prx", 257);
        this.addVshModAttribute("_satelite.prx", 257);
        this.addVshModAttribute("adhoc_transfer.prx", 0);
        this.addVshModAttribute("auth_plugin.prx", 0);
        this.addVshModAttribute("auto_connect.prx", 0);
        this.addVshModAttribute("camera_plugin.prx", 0);
        this.addVshModAttribute("common_gui.prx", 0);
        this.addVshModAttribute("common_util.prx", 0);
        this.addVshModAttribute("content_browser.prx", 0);
        this.addVshModAttribute("dd_helper.prx", 0);
        this.addVshModAttribute("dd_helper_utility.prx", 0);
        this.addVshModAttribute("dialogmain.prx", 0);
        this.addVshModAttribute("dnas_plugin.prx", 0);
        this.addVshModAttribute("file_parser_base.prx", 0);
        this.addVshModAttribute("game_install_plugin.prx", 0);
        this.addVshModAttribute("game_plugin.prx", 0);
        this.addVshModAttribute("htmlviewer_plugin.prx", 0);
        this.addVshModAttribute("htmlviewer_ui.prx", 2);
        this.addVshModAttribute("htmlviewer_utility.prx", 0);
        this.addVshModAttribute("hvauth_r.prx", 0);
        this.addVshModAttribute("impose_plugin.prx", 0);
        this.addVshModAttribute("launcher_plugin.prx", 0);
        this.addVshModAttribute("lftv_main_plugin.prx", 0);
        this.addVshModAttribute("lftv_middleware.prx", 0);
        this.addVshModAttribute("lftv_plugin.prx", 0);
        this.addVshModAttribute("libfont_arib.prx", 6);
        this.addVshModAttribute("libfont_hv.prx", 6);
        this.addVshModAttribute("libpspvmc.prx", 0);
        this.addVshModAttribute("libslim.prx", 2);
        this.addVshModAttribute("libwww.prx", 2);
        this.addVshModAttribute("marlindownloader.prx", 0);
        this.addVshModAttribute("mcore.prx", 0);
        this.addVshModAttribute("mlnapp_proxy.prx", 0);
        this.addVshModAttribute("mlnbb.prx", 0);
        this.addVshModAttribute("mlncmn.prx", 0);
        this.addVshModAttribute("mlnusb.prx", 0);
        this.addVshModAttribute("mm_flash.prx", 2);
        this.addVshModAttribute("msgdialog_plugin.prx", 0);
        this.addVshModAttribute("msvideo_main_plugin.prx", 0);
        this.addVshModAttribute("msvideo_plugin.prx", 0);
        this.addVshModAttribute("music_browser.prx", 0);
        this.addVshModAttribute("music_main_plugin.prx", 0);
        this.addVshModAttribute("music_parser.prx", 0);
        this.addVshModAttribute("music_player.prx", 0);
        this.addVshModAttribute("netconf_plugin.prx", 0);
        this.addVshModAttribute("netconf_plugin_auto_bfl.prx", 0);
        this.addVshModAttribute("netconf_plugin_auto_nec.prx", 0);
        this.addVshModAttribute("netfront.prx", 2);
        this.addVshModAttribute("netplay_client_plugin.prx", 0);
        this.addVshModAttribute("netplay_server_plus_utility.prx", 0);
        this.addVshModAttribute("netplay_server_utility.prx", 0);
        this.addVshModAttribute("netplay_server2_utility.prx", 0);
        this.addVshModAttribute("npadmin_plugin.prx", 0);
        this.addVshModAttribute("npinstaller_plugin.prx", 0);
        this.addVshModAttribute("npsignin_plugin.prx", 0);
        this.addVshModAttribute("npsignup_plugin.prx", 0);
        this.addVshModAttribute("opening_plugin.prx", 0);
        this.addVshModAttribute("osk_plugin.prx", 0);
        this.addVshModAttribute("paf.prx", 0);
        this.addVshModAttribute("pafmini.prx", 0);
        this.addVshModAttribute("photo_browser.prx", 0);
        this.addVshModAttribute("photo_main_plugin.prx", 0);
        this.addVshModAttribute("photo_player.prx", 0);
        this.addVshModAttribute("premo_plugin.prx", 0);
        this.addVshModAttribute("ps3scan_plugin.prx", 0);
        this.addVshModAttribute("psn_plugin.prx", 0);
        this.addVshModAttribute("psn_utility.prx", 0);
        this.addVshModAttribute("radioshack_plugin.prx", 0);
        this.addVshModAttribute("recommend_browser.prx", 0);
        this.addVshModAttribute("recommend_launcher_plugin.prx", 0);
        this.addVshModAttribute("recommend_main.prx", 0);
        this.addVshModAttribute("rss_browser.prx", 0);
        this.addVshModAttribute("rss_common.prx", 0);
        this.addVshModAttribute("rss_downloader.prx", 0);
        this.addVshModAttribute("rss_main_plugin.prx", 0);
        this.addVshModAttribute("rss_reader.prx", 0);
        this.addVshModAttribute("rss_subscriber.prx", 0);
        this.addVshModAttribute("savedata_auto_dialog.prx", 0);
        this.addVshModAttribute("savedata_plugin.prx", 0);
        this.addVshModAttribute("savedata_utility.prx", 0);
        this.addVshModAttribute("screenshot_plugin.prx", 0);
        this.addVshModAttribute("store_browser_plugin.prx", 0);
        this.addVshModAttribute("store_checkout_plugin.prx", 0);
        this.addVshModAttribute("store_checkout_utility.prx", 0);
        this.addVshModAttribute("subs_plugin.prx", 0);
        this.addVshModAttribute("sysconf_plugin.prx", 0);
        this.addVshModAttribute("update_plugin.prx", 0);
        this.addVshModAttribute("video_main_plugin.prx", 0);
        this.addVshModAttribute("video_plugin.prx", 0);
        this.addVshModAttribute("visualizer_plugin.prx", 0);
        this.addVshModAttribute("vshmain.prx", 2048);
        prxKle4Compression = new HashMap<String, Boolean>();
        prxKle4Compression.put("loadcore.prx", Boolean.TRUE);
        prxKle4Compression.put("kd/loadcore.prx", Boolean.TRUE);
        prxKle4Compression.put("sysmem.prx", Boolean.TRUE);
        prxKle4Compression.put("kd/sysmem.prx", Boolean.TRUE);
    }

    private boolean isPrx(String fileName) {
        return fileName.toLowerCase().endsWith(".prx");
    }

    private boolean isKl4eCompression(String fileName) {
        Boolean kle4Compression = prxKle4Compression.get(fileName.toLowerCase());
        if (kle4Compression != null) {
            return kle4Compression;
        }
        return false;
    }

    private int getModAttribute(String fileName) {
        Integer modAttribute = prxModAttribute.get(fileName.toLowerCase());
        if (modAttribute != null) {
            return modAttribute;
        }
        return 4103;
    }

    private static void write8(OutputStream os, int value) throws IOException {
        os.write(value & 0xFF);
    }

    private static void write16(OutputStream os, int value) throws IOException {
        CompressPrxVirtualFileSystem.write8(os, value);
        CompressPrxVirtualFileSystem.write8(os, value >> 8);
    }

    private static void write32(OutputStream os, int value) throws IOException {
        CompressPrxVirtualFileSystem.write8(os, value);
        CompressPrxVirtualFileSystem.write8(os, value >> 8);
        CompressPrxVirtualFileSystem.write8(os, value >> 16);
        CompressPrxVirtualFileSystem.write8(os, value >> 24);
    }

    private static void writeString(OutputStream os, String value, int length) throws IOException {
        if (value != null) {
            int n = Math.min(value.length(), length);
            for (int i = 0; i < n; ++i) {
                char c = value.charAt(i);
                CompressPrxVirtualFileSystem.write8(os, c);
            }
            length -= n;
        }
        while (length > 0) {
            --length;
            CompressPrxVirtualFileSystem.write8(os, 0);
        }
    }

    private static void writeBytes(OutputStream os, byte[] bytes, int length) throws IOException {
        if (bytes != null) {
            int n = Math.min(bytes.length, length);
            for (int i = 0; i < n; ++i) {
                CompressPrxVirtualFileSystem.write8(os, bytes[i]);
            }
            length -= n;
        }
        while (length > 0) {
            --length;
            CompressPrxVirtualFileSystem.write8(os, 0);
        }
    }

    private void writePspHeader(OutputStream os, byte[] elfFile, String fileName) throws IOException {
        int i;
        int bssSize = 0;
        int modInfoOffset = -1;
        int nSegments = 0;
        int type = Utilities.readUnaligned16(elfFile, 16);
        int bootEntry = Utilities.readUnaligned32(elfFile, 24);
        int phOffset = Utilities.readUnaligned32(elfFile, 28);
        int phEntSize = Utilities.readUnaligned16(elfFile, 42);
        int phNum = Utilities.readUnaligned16(elfFile, 44);
        int[] segAlign = new int[4];
        int[] segAddress = new int[4];
        int[] segSize = new int[4];
        for (int i2 = 0; i2 < phNum; ++i2) {
            int offset = phOffset + i2 * phEntSize;
            int phType = Utilities.readUnaligned32(elfFile, offset + 0);
            int phEntFileSize = Utilities.readUnaligned32(elfFile, offset + 16);
            int phEntMemSize = Utilities.readUnaligned32(elfFile, offset + 20);
            if (phEntMemSize > phEntFileSize) {
                bssSize += phEntMemSize - phEntFileSize;
            }
            if (phType != 1 || nSegments >= 4) continue;
            segAlign[nSegments] = Utilities.readUnaligned32(elfFile, offset + 28);
            segAddress[nSegments] = Utilities.readUnaligned32(elfFile, offset + 8);
            segSize[nSegments] = phEntMemSize;
            if (type == 65440 && nSegments == 0) {
                modInfoOffset = Utilities.readUnaligned32(elfFile, offset + 12);
            }
            ++nSegments;
        }
        int compAttribute = 1;
        boolean isKl4eCompressed = this.isKl4eCompression(fileName);
        if (isKl4eCompressed) {
            compAttribute |= 0x200;
        }
        CompressPrxVirtualFileSystem.write32(os, 1347637374);
        CompressPrxVirtualFileSystem.write16(os, this.getModAttribute(fileName));
        CompressPrxVirtualFileSystem.write16(os, compAttribute);
        CompressPrxVirtualFileSystem.write8(os, 0);
        CompressPrxVirtualFileSystem.write8(os, 0);
        CompressPrxVirtualFileSystem.writeString(os, fileName, 28);
        CompressPrxVirtualFileSystem.write8(os, 0);
        CompressPrxVirtualFileSystem.write8(os, nSegments);
        CompressPrxVirtualFileSystem.write32(os, elfFile.length);
        CompressPrxVirtualFileSystem.write32(os, 0);
        CompressPrxVirtualFileSystem.write32(os, bootEntry);
        CompressPrxVirtualFileSystem.write32(os, modInfoOffset);
        CompressPrxVirtualFileSystem.write32(os, bssSize);
        for (i = 0; i < 4; ++i) {
            CompressPrxVirtualFileSystem.write16(os, segAlign[i]);
        }
        for (i = 0; i < 4; ++i) {
            CompressPrxVirtualFileSystem.write32(os, segAddress[i]);
        }
        for (i = 0; i < 4; ++i) {
            CompressPrxVirtualFileSystem.write32(os, segSize[i]);
        }
        for (i = 0; i < 5; ++i) {
            CompressPrxVirtualFileSystem.write32(os, 0);
        }
        CompressPrxVirtualFileSystem.write32(os, 0);
        CompressPrxVirtualFileSystem.write8(os, 0);
        CompressPrxVirtualFileSystem.write8(os, 0);
        CompressPrxVirtualFileSystem.write16(os, 0);
        if (isKl4eCompressed) {
            CompressPrxVirtualFileSystem.writeBytes(os, null, 16);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 16);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 16);
            CompressPrxVirtualFileSystem.write32(os, 0);
            CompressPrxVirtualFileSystem.write32(os, 0);
            CompressPrxVirtualFileSystem.write32(os, 0);
            CompressPrxVirtualFileSystem.write32(os, 0);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 16);
            CompressPrxVirtualFileSystem.write32(os, 0);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 88);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 20);
            CompressPrxVirtualFileSystem.writeBytes(os, null, 16);
        }
    }

    private void fixPspSizeInHeader(byte[] bytes) {
        int pspSize = bytes.length;
        Utilities.writeUnaligned32(bytes, 44, pspSize);
    }

    private byte[] getCompressedPrxFile(String dirName, String fileName) {
        String proxyFileName = dirName == null || dirName.length() == 0 ? fileName : dirName + "/" + fileName;
        IVirtualFile vFileUncompressed = super.ioOpen(proxyFileName, 1, 0);
        if (vFileUncompressed == null) {
            return null;
        }
        byte[] bufferUncompressed = Utilities.readCompleteFile(vFileUncompressed);
        vFileUncompressed.ioClose();
        if (bufferUncompressed == null) {
            return null;
        }
        int headerMagic = Utilities.readUnaligned32(bufferUncompressed, 0);
        if (headerMagic != 1179403647) {
            return bufferUncompressed;
        }
        int lengthUncompressed = bufferUncompressed.length;
        ByteArrayOutputStream osCompressed = new ByteArrayOutputStream(345 + lengthUncompressed);
        try {
            this.writePspHeader(osCompressed, bufferUncompressed, fileName);
            if (this.isKl4eCompression(fileName)) {
                CompressPrxVirtualFileSystem.writeString(osCompressed, "KL4E", 4);
                CompressPrxVirtualFileSystem.write8(osCompressed, 128);
                CompressPrxVirtualFileSystem.write32(osCompressed, Utilities.endianSwap32(lengthUncompressed));
                CompressPrxVirtualFileSystem.writeBytes(osCompressed, bufferUncompressed, lengthUncompressed);
            } else {
                GZIPOutputStream os = new GZIPOutputStream(osCompressed);
                os.write(bufferUncompressed, 0, lengthUncompressed);
                os.close();
            }
        }
        catch (IOException os) {
            // empty catch block
        }
        byte[] bytes = osCompressed.toByteArray();
        this.fixPspSizeInHeader(bytes);
        return bytes;
    }

    private long getCompressedPrxSize(String dirName, String fileName) {
        byte[] compressedFile = this.getCompressedPrxFile(dirName, fileName);
        if (compressedFile == null) {
            return 0L;
        }
        return compressedFile.length;
    }

    @Override
    public int ioDread(String dirName, SceIoDirent dir) {
        int result = super.ioDread(dirName, dir);
        if (this.isPrx(dir.filename)) {
            dir.stat.size = this.getCompressedPrxSize(dirName, dir.filename);
        }
        return result;
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        if (this.isPrx(fileName) && (flags & 3) == 1) {
            return new ByteArrayVirtualFile(this.getCompressedPrxFile(null, fileName));
        }
        return super.ioOpen(fileName, flags, mode);
    }
}

